/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import org.bouncycastle.jcajce.provider.digest.Keccak;

public class CoinFormatHelper {
    public static boolean isEthereumAddressHash(String string) {
        if (string.substring(0, 2).equals("0x")) {
            string = string.substring(2);
        }
        String string2 = string.toLowerCase();
        Keccak.Digest256 digest256 = new Keccak.Digest256();
        byte[] byArray = string2.getBytes();
        byte[] byArray2 = digest256.digest(byArray);
        String string3 = HexFormat.of().formatHex(byArray2);
        StringBuilder stringBuilder = new StringBuilder(string2);
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            int n = Character.digit(string3.charAt(i), 16);
            if (n >= 8) {
                stringBuilder.setCharAt(i, Character.toUpperCase(c));
                continue;
            }
            stringBuilder.setCharAt(i, Character.toLowerCase(c));
        }
        return string.equals(stringBuilder.toString());
    }

    public static String fixEthereumAddressCapitalization(String string) {
        if (string.substring(0, 2).equals("0x")) {
            string = string.substring(2);
        }
        String string2 = string.toLowerCase();
        Keccak.Digest256 digest256 = new Keccak.Digest256();
        byte[] byArray = string2.getBytes();
        byte[] byArray2 = digest256.digest(byArray);
        String string3 = HexFormat.of().formatHex(byArray2);
        StringBuilder stringBuilder = new StringBuilder(string2);
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            int n = Character.digit(string3.charAt(i), 16);
            if (n >= 8) {
                stringBuilder.setCharAt(i, Character.toUpperCase(c));
                continue;
            }
            stringBuilder.setCharAt(i, Character.toLowerCase(c));
        }
        return stringBuilder.toString();
    }

    public static boolean isBitcoinP2WPKHAddressHash(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String string2 = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
        int n7 = 0;
        for (n6 = 0; n6 < string.length(); ++n6) {
            if (string.charAt(n6) != '1') continue;
            n7 = n6;
        }
        if (n7 == 0) {
            return false;
        }
        String string3 = string.substring(0, n7);
        String string4 = string.substring(n7 + 1);
        if (string3.length() == 0 || string4.length() == 0) {
            return false;
        }
        if (!string3.equalsIgnoreCase("bc")) {
            return false;
        }
        int[] nArray = new int[string4.length()];
        for (n6 = 0; n6 < string4.length(); ++n6) {
            n5 = string4.charAt(n6);
            for (n4 = 0; n4 < string2.length(); ++n4) {
                if (string2.charAt(n4) != n5) continue;
                nArray[n6] = n4;
            }
        }
        if (nArray.length < 8) {
            return false;
        }
        n5 = nArray[0];
        int[] nArray2 = new int[nArray.length - 7];
        int[] nArray3 = new int[6];
        for (n6 = 1; n6 < nArray.length - 6; ++n6) {
            nArray2[n6 - 1] = nArray[n6];
        }
        n4 = 0;
        for (n6 = nArray.length - 6; n6 < nArray.length; ++n6) {
            nArray3[n4] = nArray[n6];
            ++n4;
        }
        int[] nArray4 = new int[string3.length() * 2 + 1];
        nArray4[string3.length()] = 0;
        for (n6 = 0; n6 < string3.length(); ++n6) {
            int n8;
            n3 = n8 = string3.charAt(n6);
            n2 = (n3 & 0xE0) >> 5;
            n = n3 & 0x1F;
            nArray4[n6] = n2;
            nArray4[string3.length() + 1 + n6] = n;
        }
        int[] nArray5 = new int[nArray4.length + 1 + nArray2.length + 6];
        for (n6 = 0; n6 < nArray4.length; ++n6) {
            nArray5[n6] = nArray4[n6];
        }
        nArray5[nArray4.length] = n5;
        for (n6 = nArray4.length + 1; n6 < nArray4.length + 1 + nArray2.length; ++n6) {
            nArray5[n6] = nArray2[n6 - nArray4.length - 1];
        }
        for (n6 = nArray5.length - 6; n6 < nArray5.length; ++n6) {
            nArray5[n6] = 0;
        }
        n3 = 1;
        int n9 = 0;
        int n10 = 996825010;
        int n11 = 642813549;
        int n12 = 513874426;
        int n13 = 1027748829;
        int n14 = 705979059;
        for (n6 = 0; n6 < nArray5.length; ++n6) {
            n2 = (n3 & 0x3E000000) >> 25;
            n = n3 & 0x1FFFFFF;
            int n15 = n << 5;
            n9 = n15 ^ nArray5[n6];
            int n16 = n2 & 1;
            if (n16 != 0) {
                n9 ^= n10;
            }
            if ((n16 = n2 & 2) != 0) {
                n9 ^= n11;
            }
            if ((n16 = n2 & 4) != 0) {
                n9 ^= n12;
            }
            if ((n16 = n2 & 8) != 0) {
                n9 ^= n13;
            }
            if ((n16 = n2 & 0x10) != 0) {
                n9 ^= n14;
            }
            n3 = n9;
        }
        n3 = n9 ^ 1;
        int[] nArray6 = new int[]{(n3 & 0x3E000000) >> 25, (n3 & 0x1F00000) >> 20, (n3 & 0xF8000) >> 15, (n3 & 0x7C00) >> 10, (n3 & 0x3E0) >> 5, n3 & 0x1F};
        for (n6 = 0; n6 < 6; ++n6) {
            if (nArray3[n6] == nArray6[n6]) continue;
            return false;
        }
        return true;
    }

    public static boolean isBitcoinP2TRAddressHash(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String string2 = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
        int n7 = 0;
        for (n6 = 0; n6 < string.length(); ++n6) {
            if (string.charAt(n6) != '1') continue;
            n7 = n6;
        }
        if (n7 == 0) {
            return false;
        }
        String string3 = string.substring(0, n7);
        String string4 = string.substring(n7 + 1);
        if (string3.length() == 0 || string4.length() == 0) {
            return false;
        }
        if (!string3.equalsIgnoreCase("bc")) {
            return false;
        }
        int[] nArray = new int[string4.length()];
        for (n6 = 0; n6 < string4.length(); ++n6) {
            n5 = string4.charAt(n6);
            for (n4 = 0; n4 < string2.length(); ++n4) {
                if (string2.charAt(n4) != n5) continue;
                nArray[n6] = n4;
            }
        }
        if (nArray.length < 8) {
            return false;
        }
        n5 = nArray[0];
        int[] nArray2 = new int[nArray.length - 7];
        int[] nArray3 = new int[6];
        for (n6 = 1; n6 < nArray.length - 6; ++n6) {
            nArray2[n6 - 1] = nArray[n6];
        }
        n4 = 0;
        for (n6 = nArray.length - 6; n6 < nArray.length; ++n6) {
            nArray3[n4] = nArray[n6];
            ++n4;
        }
        int[] nArray4 = new int[string3.length() * 2 + 1];
        nArray4[string3.length()] = 0;
        for (n6 = 0; n6 < string3.length(); ++n6) {
            int n8;
            n3 = n8 = string3.charAt(n6);
            n2 = (n3 & 0xE0) >> 5;
            n = n3 & 0x1F;
            nArray4[n6] = n2;
            nArray4[string3.length() + 1 + n6] = n;
        }
        int[] nArray5 = new int[nArray4.length + 1 + nArray2.length + 6];
        for (n6 = 0; n6 < nArray4.length; ++n6) {
            nArray5[n6] = nArray4[n6];
        }
        nArray5[nArray4.length] = n5;
        for (n6 = nArray4.length + 1; n6 < nArray4.length + 1 + nArray2.length; ++n6) {
            nArray5[n6] = nArray2[n6 - nArray4.length - 1];
        }
        for (n6 = nArray5.length - 6; n6 < nArray5.length; ++n6) {
            nArray5[n6] = 0;
        }
        n3 = 1;
        int n9 = 0;
        int n10 = 996825010;
        int n11 = 642813549;
        int n12 = 513874426;
        int n13 = 1027748829;
        int n14 = 705979059;
        for (n6 = 0; n6 < nArray5.length; ++n6) {
            n2 = (n3 & 0x3E000000) >> 25;
            n = n3 & 0x1FFFFFF;
            int n15 = n << 5;
            n9 = n15 ^ nArray5[n6];
            int n16 = n2 & 1;
            if (n16 != 0) {
                n9 ^= n10;
            }
            if ((n16 = n2 & 2) != 0) {
                n9 ^= n11;
            }
            if ((n16 = n2 & 4) != 0) {
                n9 ^= n12;
            }
            if ((n16 = n2 & 8) != 0) {
                n9 ^= n13;
            }
            if ((n16 = n2 & 0x10) != 0) {
                n9 ^= n14;
            }
            n3 = n9;
        }
        n3 = n9 ^ 0x2BC830A3;
        int[] nArray6 = new int[]{(n3 & 0x3E000000) >> 25, (n3 & 0x1F00000) >> 20, (n3 & 0xF8000) >> 15, (n3 & 0x7C00) >> 10, (n3 & 0x3E0) >> 5, n3 & 0x1F};
        for (n6 = 0; n6 < 6; ++n6) {
            if (nArray3[n6] == nArray6[n6]) continue;
            return false;
        }
        return true;
    }

    public static BigInteger base58tobigint(String string) {
        String string2 = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
        BigInteger bigInteger = new BigInteger("0", 10);
        for (int i = string.length() - 1; i >= 0; --i) {
            BigInteger bigInteger2 = new BigInteger("0", 10);
            BigInteger bigInteger3 = new BigInteger("58", 10);
            for (int j = 0; j < 58; ++j) {
                if (string.charAt(i) != string2.charAt(j)) continue;
                bigInteger2 = new BigInteger(String.valueOf(j), 10);
            }
            bigInteger3 = bigInteger3.pow(string.length() - 1 - i);
            bigInteger = bigInteger.add(bigInteger2.multiply(bigInteger3));
        }
        return bigInteger;
    }

    public static byte[] ripplebase58tobytearray(String string) {
        String string2 = "rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz";
        BigInteger bigInteger = new BigInteger("0", 10);
        BigInteger bigInteger2 = new BigInteger("58", 10);
        BigInteger bigInteger3 = new BigInteger("0", 10);
        for (int i = string.length() - 1; i >= 0; --i) {
            BigInteger bigInteger4 = new BigInteger("0", 10);
            BigInteger bigInteger5 = new BigInteger("58", 10);
            for (int j = 0; j < 58; ++j) {
                if (string.charAt(i) != string2.charAt(j)) continue;
                bigInteger4 = new BigInteger(String.valueOf(j), 10);
            }
            bigInteger5 = bigInteger5.pow(string.length() - 1 - i);
            bigInteger3 = bigInteger3.add(bigInteger4.multiply(bigInteger5));
        }
        byte[] byArray = bigInteger3.toByteArray();
        if (byArray.length > 1 && byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        int n = 0;
        for (int i = 0; i < string.length() && string.charAt(i) == 'r'; ++i) {
            ++n;
        }
        byte[] byArray3 = new byte[byArray.length + n];
        System.arraycopy(byArray, 0, byArray3, n, byArray.length);
        byArray = byArray3;
        return byArray;
    }

    public static String biginttobase58(BigInteger bigInteger) {
        boolean bl = false;
        boolean bl2 = false;
        BigInteger bigInteger2 = new BigInteger("58", 10);
        Object object = "";
        String string = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
        BigInteger bigInteger3 = new BigInteger(bigInteger.toString());
        while (!bigInteger3.toString().equals("0")) {
            BigInteger bigInteger4 = new BigInteger(bigInteger3.mod(bigInteger2).toString());
            object = string.charAt(bigInteger4.intValue()) + (String)object;
            BigInteger bigInteger5 = bigInteger3.divide(bigInteger2);
            bigInteger3 = new BigInteger(bigInteger5.toString());
        }
        return object;
    }

    public static boolean isRawBitcoinPrivateKey(String string, int n) {
        switch (n) {
            case 2: {
                return string.length() <= 256;
            }
            case 16: {
                return string.length() <= 64;
            }
            case 10: {
                BigInteger bigInteger = new BigInteger(string, n);
                return bigInteger.toString(16).length() <= 64;
            }
            case 58: {
                BigInteger bigInteger = CoinFormatHelper.base58tobigint(string);
                return bigInteger.toString(16).length() <= 64;
            }
        }
        return false;
    }

    public static boolean isBitcoinWIFPrivateKeyChecksum(String string) {
        BigInteger bigInteger = new BigInteger("0", 10);
        String string2 = "";
        String string3 = "";
        String string4 = "";
        bigInteger = CoinFormatHelper.base58tobigint(string);
        string2 = bigInteger.toString(16);
        if ((string.length() != 51 || string.charAt(0) != '5') && (string.length() != 52 || string.charAt(0) != 'K' && string.charAt(0) != 'L')) {
            return false;
        }
        String string5 = string2.substring(0, 2);
        if (!string5.equals("80")) {
            return false;
        }
        string3 = string2.substring(0, string2.length() - 8);
        string4 = string2.substring(string2.length() - 8, string2.length());
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray = CoinFormatHelper.hexStringToByteArray(string3);
            String string6 = CoinFormatHelper.toHexString(byArray);
            byte[] byArray2 = messageDigest.digest(byArray);
            byte[] byArray3 = messageDigest.digest(byArray2);
            String string7 = CoinFormatHelper.toHexString(byArray3);
            return string4.equalsIgnoreCase(string7.substring(0, 8));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
    }

    public static byte[] hexStringToByteArray(String object) {
        if (((String)object).length() == 0) {
            return new byte[0];
        }
        if (((String)object).length() % 2 != 0) {
            object = "0" + (String)object;
        }
        int n = ((String)object).length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            int n2 = Character.digit(((String)object).charAt(i), 16);
            int n3 = Character.digit(((String)object).charAt(i + 1), 16);
            byArray[i / 2] = (byte)((n2 << 4) + n3);
        }
        return byArray;
    }

    public static String toHexString(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] cArray2 = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray2[i * 2] = cArray[n / 16];
            cArray2[i * 2 + 1] = cArray[n % 16];
        }
        return new String(cArray2);
    }

    public static boolean isBitcoinCompressedPublicKey(BigInteger bigInteger) {
        Object object = bigInteger.toString(16);
        return ((String)(object = "0" + (String)object)).length() == 66 && ((String)object).charAt(0) == '0' && (((String)object).charAt(1) == '2' || ((String)object).charAt(1) == '3');
    }

    public static boolean isBitcoinUncompressedPublicKey(BigInteger bigInteger) {
        Object object = bigInteger.toString(16);
        return ((String)(object = "0" + (String)object)).length() == 130 && ((String)object).charAt(0) == '0' && ((String)object).charAt(1) == '4';
    }

    public static boolean isBitcoinPublicKey(BigInteger bigInteger) {
        if (CoinFormatHelper.isBitcoinCompressedPublicKey(bigInteger)) {
            return true;
        }
        return CoinFormatHelper.isBitcoinUncompressedPublicKey(bigInteger);
    }

    public static boolean isBitcoinP2PKHAddressHash(String string) {
        BigInteger bigInteger = new BigInteger("0", 10);
        bigInteger = CoinFormatHelper.base58tobigint(string);
        Object object = bigInteger.toString(16);
        object = "00" + (String)object;
        String string2 = ((String)object).substring(0, 2);
        String string3 = ((String)object).substring(2, 42);
        String string4 = ((String)object).substring(((String)object).length() - 8, ((String)object).length());
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray = CoinFormatHelper.hexStringToByteArray(string2 + string3);
            byte[] byArray2 = messageDigest.digest(byArray);
            byte[] byArray3 = messageDigest.digest(byArray2);
            String string5 = CoinFormatHelper.toHexString(byArray3);
            return string4.equalsIgnoreCase(string5.substring(0, 8));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
    }

    public static boolean isTronAddressHash(String string) {
        if (string.length() != 34) {
            return false;
        }
        BigInteger bigInteger = new BigInteger("0", 10);
        bigInteger = CoinFormatHelper.base58tobigint(string);
        String string2 = bigInteger.toString(16);
        String string3 = string2.substring(0, 2);
        String string4 = string2.substring(string2.length() - 8, string2.length());
        String string5 = string2.substring(2, string2.length() - 8);
        if (!string3.equals("41")) {
            return false;
        }
        try {
            byte[] byArray = CoinFormatHelper.hexStringToByteArray(string3 + string5);
            if (byArray.length != 21) {
                return false;
            }
            String string6 = CoinFormatHelper.toHexString(byArray);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray2 = messageDigest.digest(byArray);
            String string7 = CoinFormatHelper.toHexString(byArray2);
            byte[] byArray3 = messageDigest.digest(byArray2);
            String string8 = CoinFormatHelper.toHexString(byArray3);
            String string9 = string8.substring(0, 8);
            return string9.equalsIgnoreCase(string4);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isRippleAddressHash(String string) {
        if (string.length() < 25 || string.length() > 35) {
            return false;
        }
        byte[] byArray = CoinFormatHelper.ripplebase58tobytearray(string);
        if (byArray.length != 25) {
            return false;
        }
        byte[] byArray2 = new byte[]{byArray[0]};
        if (byArray2[0] != 0) {
            return false;
        }
        byte[] byArray3 = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray3[i] = byArray[byArray.length - 4 + i];
        }
        byte[] byArray4 = new byte[20];
        for (int i = 0; i < 20; ++i) {
            byArray4[i] = byArray[i + 1];
        }
        try {
            byte[] byArray5 = new byte[21];
            byArray5[0] = byArray2[0];
            for (int i = 0; i < 20; ++i) {
                byArray5[i + 1] = byArray4[i];
            }
            String string2 = CoinFormatHelper.toHexString(byArray5);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray6 = messageDigest.digest(byArray5);
            String string3 = CoinFormatHelper.toHexString(byArray6);
            byte[] byArray7 = messageDigest.digest(byArray6);
            String string4 = CoinFormatHelper.toHexString(byArray7);
            String string5 = string4.substring(0, 8);
            for (int i = 0; i < 4; ++i) {
                if (byArray7[i] == byArray3[i]) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

